uniform sampler2D depthpacked,normal,ao_tex;
uniform float strength;
uniform float blur_min_normal;
uniform int direction;
uniform float out_mix;

float unpackFloatFromVec3i(const vec3 value)
{
	const vec3 bitSh = vec3( 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
	return(dot(value, bitSh));
}
float getdepth(vec2 xy)
{
	float depth;
	vec3 col=texture2D(depthpacked,xy).xyz;
	if(col.x==0.0 && col.y==0.0 && col.z==0.0)
		depth=1000000000.0;
	else
		depth=unpackFloatFromVec3i(col);
	return depth;
}
vec3 normalgen(vec2 v)
{
	return texture2D(normal,v).xyz;
}
void main()
{
	vec2 uv=gl_TexCoord[0].xy,newuv,uv2;
	int i,u=0;
	float depth=getdepth(uv);
	vec2 uvadd;
	vec3 nor = texture2D(normal,uv).xyz;
	uvadd.xy = (nor.xy-vec2(0.5));
	float angle = dot(vec2(1,0),uvadd);
	float divider = (0.5+pow(angle,2));
	if(direction != 0)
		angle+=3.1415/2.0;
	uvadd.x = cos(angle)/divider;
	uvadd.y = sin(angle)/divider;
	uvadd = normalize(uvadd);
	uvadd/=vec2(3000);
	vec4 col=vec4(0);
	vec3 nd;
	for(i=-4;i<4;i++)
	{
		uv2=uv+uvadd*float(i)*strength*.05/(depth);
		//  proverava da li oba tacaka pripadaju istoj povrsini
		if((blur_min_normal <= 0.0) || (distance(nor,texture2D(normal,uv2).xyz)<blur_min_normal))
		{
			col+=texture2D(ao_tex,uv2);
			u++;
		}
	}
	gl_FragColor = vec4(out_mix) * vec4(col)/vec4(u) + vec4(1.0-out_mix) * texture2D(ao_tex,uv);
}

